/** @file   playercontroller.cpp
 * @brief   Implementation of PlayerController - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "playercontroller.h"
#include "settings.h"
#include "www_map.h"


namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
PlayerController::PlayerController( GameObject* pObj ) :
  BaseController( pObj ),
  iPreviousWeapon(0)
{
}



/** Destructor
 */
PlayerController::~PlayerController()
{
}




///
/// Public methods
/// ==============

/** Updates this controller
 */
void PlayerController::update()
{
  this->reset();
  
  // Read the mouse and update the variables
  int mx;
  int my;
  get_mouse_mickeys( &mx, &my );
  this->scaleRelativeMouse( &mx, &my );
  m_turn = mx;
  
  // Back and forth movement
  if ( key[ Settings::key_up ] ) {
    m_forward = 1;
    
  } else if ( key[ Settings::key_down ] ) {
    m_backward = 1;
    
  }
  
  // left/right movement
  if ( key[Settings::key_left ] ) {
    m_left = 1;
    
  } else if ( key[ Settings::key_right ] ) {
    m_right = 1;
    
  }
  
  // grenade
  if ( key[Settings::key_grenade] ) {
    m_grenade = 1;
  }
  
  // shooting
  if ( mouse_b & 1 ) {
    m_shoot = 1;
  }
  
  // detonating
  if ( key[ Settings::key_detonate ] ) {
    m_detonate = 1;
  }
  
  // The position of the sight
  m_sightX = mouse_x + Map::scrollX;
  m_sightY = mouse_y + Map::scrollY;
  
  // Check for possible weaponchanges
  m_weaponChange = 0;
  if ( key[KEY_1] ) {
    m_weaponChange = 1;
  } else if ( key[KEY_2] ) {
    m_weaponChange = 2;
  } else if ( key[KEY_3] ) {
    m_weaponChange = 3;
  } else if ( key[KEY_4] ) {
    m_weaponChange = 4;
  } else if ( key[KEY_5] ) {
    m_weaponChange = 5;
  } else if ( key[KEY_6] ) {
    m_weaponChange = 6;
  } else if ( key[KEY_7] ) {
    m_weaponChange = 7;
  } else if ( key[KEY_8] ) {
    m_weaponChange = 8;
  }
  
  /** Check the mouse wheel */
  if ( mouse_z > 3 ) {
    iPreviousWeapon -= 1;
    if ( iPreviousWeapon < 1 ) {
      iPreviousWeapon = 1;
    }
    m_weaponChange = iPreviousWeapon;
    
    position_mouse_z( 0 );
    
  } else if ( mouse_z < -3 ) {
    iPreviousWeapon += 1;
    if ( iPreviousWeapon > 8 ) {
      iPreviousWeapon = 8;
    }
    m_weaponChange = iPreviousWeapon;
    position_mouse_z( 0 );
    
  }
}



/** Resets this controller
 */
void PlayerController::reset()
{
  BaseController::reset();
  m_grenade = 0;
  m_detonate = 0;
  m_weaponChange = -1;
}




///
/// Getter methods
/// ==============






///
/// Private or Protected methods
/// ============================

/** Scales the mouse movents
 */
void PlayerController::scaleRelativeMouse( int* pX, int* pY ) const
{
  if ( abs(*pX) < 10 && abs(*pX) > 1 ) {
    *pX /= 2;
      
  } else if ( abs(*pX) < 20 ) {
    *pX /= 3;
      
  } else if ( abs(*pX) < 40 ) {
    *pX /= 5;
      
  } else if ( abs(*pX) < 80 ) {
    *pX /= 8;
      
  } else {
    *pX /= 13;
      
  }
}
} // end of namespace

/**
 * Version history
 * ===============
 * $Log: playercontroller.cpp,v $
 * Revision 1.2  2006/08/20 21:13:54  lamminsa
 * Mouse wheel support for weapon change.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.2  2006-01-10 22:58:52+02  lamminsa
 * Mouse wheel support added.
 *
 * Revision 1.1  2005-11-13 14:53:32+02  lamminsa
 * m_weaponChange gets nulled if no weapon change is made.
 *
 */
 
